/*************************************
 *				     	             *
 * ļ: 02 Ա\11 Polynomial *
 * 					                 *
 * ļ: Polynomial.c              *
 * 				                     *
 *   : 2.222.23                * 
 *                                   *
 *************************************/

#ifndef	POLYNOMIAL_C
#define	POLYNOMIAL_C

#include "Polynomial.h"					//**02 Ա**//

/*TTTTT[
U 㷨2.22 U 
^TTTTT*/
void CreatPolyn_P(FILE *fp, Polynomial *P, int m)
{
	PositionPtr h;
	ElemType_P e;
	int i;
	Link p;

	InitList_E(P);						//ʼһչĵŶʽ 
	h = GetHead_E(*P);					//ȡʽͷָ 

	e.coef = 0.0;
	e.expn = -1;
	SetCurElem_E(h, e);			    	//ͷԪ 
	h->next = NULL;
	
	for(i=1; i<=m; i++)					//¼n0 
	{
		Scanf(fp, "%f%d", &(e.coef), &(e.expn));
		MakeNode_E(&p, e);
		p->next = NULL;
		InsFirst_E(P, h, p);
		h = h->next;
	} 
} 

void DestroyPolyn_P(Polynomial *P)
{
	DestroyList_E(P);
}

int PolynLength_P(Polynomial P)
{
	return ListLength_E(P);
}

/*TTTTT[
U 㷨2.23 U 
^TTTTT*/
void AddPolyn_P(Polynomial *Pa, Polynomial *Pb)
{
	PositionPtr ha, hb;
	PositionPtr qa, qb;
	ElemType_P a, b;
	float sum;
	 
	ha = GetHead_E(*Pa);					//hahbֱָPaPbͷ 
	hb = GetHead_E(*Pb);	
	qa = NextPos_E(ha);						//qaqbֱָPaPbĵǰ
	qb = NextPos_E(hb);

	while(qa && qb)							//qaqbǿ
	{
		a = GetCurElem_E(qa);				//abΪеǰȽԪ 
		b = GetCurElem_E(qb);

		switch(Cmp_exp(a,b))				//ȽϵǰԪصָС 
		{
			case -1:						//ʽPaеǰֵָС
				ha = qa;
				qa = NextPos_E(ha);
				break;
			case 0:							//ֵ 
				sum = a.coef + b.coef;
				if(sum != 0.0)				//ӲܵʱPaϵֵ 
				{
					qa->data.coef = sum;
					SetCurElem_E(qa, qa->data);
					ha = qa;				//ʱha 
				}
				else						//ӵʱɾPaеǰ
				{
					DelFirst_E(Pa, ha, &qa);
					FreeNode_E(&qa);
				}
				DelFirst_E(Pb, hb, &qb);	//ɾPbɨĽ 
				FreeNode_E(&qb);
				qb = NextPos_E(hb);			//qaqb 
				qa = NextPos_E(ha);
				break;
			case 1:							//ʽPbеǰֵָС
				DelFirst_E(Pb, hb, &qb);	//ժPbǰ
				InsFirst_E(Pa, ha, qb); 	//ժ½Pa
				qb = NextPos_E(hb);
				ha = NextPos_E(ha); 
				break; 
		}//switch
	}//while
	
	if(qb)									//Pbδɨ꣬ʣӵPa 
		Append_E(Pa, qb);

	FreeNode_E(&hb);						//ͷPbͷ
	(*Pb).head = (*Pb).tail = NULL;			//PbΪ״̬ 
	(*Pb).len = 0;		 
}

void SubtractPolyn_P(Polynomial *Pa, Polynomial *Pb)
{
	PositionPtr ha, hb;
	PositionPtr qa, qb;
	PositionPtr r;
	ElemType_P a, b;
	float sum;
	 
	ha = GetHead_E(*Pa);					//hahbֱָPaPbͷ 
	hb = GetHead_E(*Pb);	
	qa = NextPos_E(ha);						//qaqbֱָPaPbĵǰ
	qb = NextPos_E(hb);
	
	while(qa && qb)							//qaqbǿ
	{
		a = GetCurElem_E(qa);				//abΪеǰȽԪ 
		b = GetCurElem_E(qb);

		switch(Cmp_exp(a,b))				//ȽϵǰԪصָС 
		{
			case -1:						//ʽPaеǰֵָС
				ha = qa;
				qa = NextPos_E(ha);
				break;
			case 0:							//ֵ 
				sum = a.coef - b.coef;
				if(sum != 0.0)				//ܵʱPaϵֵ 
				{
					qa->data.coef = sum;
					SetCurElem_E(qa, qa->data);
					ha = qa;				//ʱha 
				}
				else						//ӵʱɾPaеǰ
				{
					DelFirst_E(Pa, ha, &qa);
					FreeNode_E(&qa);
				}
				DelFirst_E(Pb, hb, &qb);	//ɾPbɨĽ 
				FreeNode_E(&qb);
				qb = NextPos_E(hb);			//qaqb 
				qa = NextPos_E(ha);
				break;
			case 1:							//ʽPbеǰֵָС
				DelFirst_E(Pb, hb, &qb);	//ժPbǰ
				qb->data.coef = - qb->data.coef;	//ı䵱ǰ 
				InsFirst_E(Pa, ha, qb); 	//ժ½Pa
				qb = NextPos_E(hb);
				ha = NextPos_E(ha); 
				break; 
		}//switch
	}//while

	if(qb)									//Pbδɨ
	{
		r = qb;
		while(r)							
		{
			r->data.coef = - r->data.coef;	//ıʣ 
			r = r->next;
		}
		Append_E(Pa, qb);	
	} 

	FreeNode_E(&hb);						//ͷPbͷ
	(*Pb).head = (*Pb).tail = NULL;
	(*Pb).len = 0;
}

void MultiplyPolyn_P(Polynomial *Pa, Polynomial *Pb)
{
	Polynomial Pc, Ptmp;
	int i, j, la, lb;
	PositionPtr ha;
	PositionPtr qa, qb;
	Link s;
	
	la = PolynLength_P(*Pa);
	lb = PolynLength_P(*Pb);
	ha = (*Pa).head;

	InitList_E(&Pc);
	
	for(i=1; i<=la; i++)
	{
		InitList_E(&Ptmp);

		DelFirst_E(Pa, ha, &qa);
		qb = (*Pb).head->next;

		for(j=1; j<=lb; j++)
		{
			s = (Link)malloc(sizeof(ELNode));				//ռ 	
			if(!s)
				exit(OVERFLOW);
			
			s->data.coef = qa->data.coef * qb->data.coef;	//ϵ 
			s->data.expn = qa->data.expn + qb->data.expn;	//ָ 
			s->next = NULL;
			
			Append_E(&Ptmp, s);
			 
			qb = qb->next;
		}
		
		AddPolyn_P(&Pc, &Ptmp);		
	}
	
	AddPolyn_P(Pa, &Pc);
	
	DestroyPolyn_P(Pb);
}

int Cmp_exp(ElemType_P c1, ElemType_P c2)
{
	int i = c1.expn - c2.expn; 
	
	if(i<0)
		return -1;
	else if(i==0)
		return 0;
	else
		return 1;
} 

void PrintPolyn_P(Polynomial P)
{
	int i;
	Link p;
	
	p = P.head->next;
	for(i=1; i<=P.len; i++)
	{
		if(i==1)
			printf("%g", p->data.coef);
		else
		{
			if(p->data.coef>0)
			{
				printf(" + ");
				printf("%g", p->data.coef);
			}
			else
			{
				printf(" - ");
				printf("%g", -p->data.coef);
			}				
		}
		
		if(p->data.expn)
		{
			printf("x");
			
			if(p->data.expn!=1)
				printf("^%d", p->data.expn);
		}
		
		p = p->next;
	}
}

#endif
